#ifndef utils_hpp
#define utils_hpp

#include <string>
#include <type_traits>
#include <vector>
#include <stdexcept>
#include "phylogenetics.hpp"

/*
Converts a double to a string with nice rounding.
You should use this function when converting any double to a string in your
code!
*/
std::string double_to_string(double d);

std::vector<Taxon> readSequencesFromFile(const std::string& filename);

/*
    =================================
    WARNING: YOU SHOULD NOT MODIFY IT
    =================================

    This class provides an exception for a function that has not been 
    implemented yet
*/

#define NotImplemented() throw NotImplementedError(__PRETTY_FUNCTION__)

class NotImplementedError : public std::logic_error {
   public:
    NotImplementedError()
        : NotImplementedError("Not implemented", __FUNCTION__) {}
    NotImplementedError(const char* function)
        : NotImplementedError("Function Not implemented =>", function) {}

    virtual const char* what() const throw() { return __text.c_str(); }

   private:
    NotImplementedError(const char* message, const char* function)
        : std::logic_error("Not Implemented") {
        __text = message;
        __text += " : ";
        __text += function;
    }

    std::string __text;
};

#endif
