#include "utils.hpp"

#include <fstream>
#include <iostream>
#include <sstream>

/*
    This function takes the double d and convert it to a string.
    Use it for consistency with our tests.
*/
std::string double_to_string(double d) {
    std::stringstream ss;
    ss << d;
    return ss.str();
}

/*
    Utility function that reads a file and returns a vector of Taxon
*/
std::vector<Taxon> readSequencesFromFile(const std::string& filename) {
    std::vector<Taxon> sequences;
    std::ifstream file(filename);
    std::string line;

    if (file.is_open()) {
        while (getline(file, line)) {
            sequences.push_back(line);
        }
        file.close();
    } else {
        std::cerr << "Unable to open file: " + filename << std::endl;
    }

    return sequences;
}
