#pragma once

#include <string>

#include "phylogenetics.hpp"

/*
    For unit tests
*/

bool doubles_equal(double double1, double double2, double precision = 1e-8);
bool operator==(Cluster const& cluster1, Cluster const& cluster2);
bool operator==(ClusterIdPair const& pair1, ClusterIdPair const& pair2);
bool operator==(Tree const& tree1, Tree const& tree2);

void check(bool condition, std::string const& fail_message);
void check_equal(bool is_equal, std::string const& expected,
                 std::string const& actual);
void check_equal(int expected, int actual);
void check_equal(double expected, double actual, double precision);
void check_equal(std::string const& expected, std::string const& actual);
void check_equal(Cluster const& expected, Cluster const& actual);
void check_equal(DistanceMatrix const& expected, DistanceMatrix const& actual);
void check_equal(ClusterIdPair const& expected, ClusterIdPair const& actual);
void check_equal(Tree const& expected, Tree const& actual);
