#ifndef phylogenetics_hpp
#define phylogenetics_hpp

#include <array>
#include <set>
#include <string>
#include <vector>

/*
    ============================================================
    WARNING: Do not modify the definition of the following types
    ============================================================
*/

typedef std::string Taxon;

struct Cluster {
    Taxon taxon = "";
    int id = -1;
    double height = 0;
    Cluster* left = 0;
    Cluster* right = 0;
    size_t size = 1;
};

typedef std::array<size_t, 2> ClusterIdPair;
typedef std::vector<Cluster*> Tree;
typedef std::vector<std::vector<double>> DistanceMatrix;

enum AlgoType { WPGMA, UPGMA, NUMALGO };

/*
    ===============================================================
    WARNING: Do not modify the signature of the following functions
    ===============================================================
*/

/*
    Part 1
*/

std::string toString(const DistanceMatrix& matrix, bool verbose = false);

std::string clusterToString(const Cluster* cluster, bool verbose = false);

std::string toString(const ClusterIdPair& pair);

std::string toString(const Tree& tree, bool verbose = false);

/*
    Part 2
*/
int calculateDistance(const Taxon& seq1, const Taxon& seq2);

Tree initTree(std::vector<Taxon> taxa);
void deleteTree(Tree& tree);

DistanceMatrix initDistanceMatrix(const Tree& tree);
void eraseColumn(DistanceMatrix& distances, size_t c);
void eraseRow(DistanceMatrix& distances, size_t c);

/*
    Part 3
*/
ClusterIdPair minimumDistance(const DistanceMatrix& distances);
void mergeClusters(const ClusterIdPair& pair, Tree& tree,
                   DistanceMatrix& distances, AlgoType algorithm = WPGMA);
void buildPhylogeneticTree(Tree& tree, DistanceMatrix& distances,
                           AlgoType algorithm = WPGMA);

std::string phylogeneticTreeToString(const Cluster* root, bool verbose = false);

#endif /* phylogenetics_hpp */
